from gmpy2 import *            # Calcul sur les grands nombres
from Crypto.Util.number import long_to_bytes

e = 65537
n = 66907891761984008537941140774912037297837590014015185566914783649941599498156196985198017994785898068818408452278114397257705910683663630148281632249325838499714790225183956363183023909759661407982053628973343763791901162941487843952027091158708062588427508128442517340524304210772219119731017090655544774543
c = 5133911099057224667169583602683674532556802478109001219004962180674003744338654654215037333471991641567067921343617795171381818207050522146661135917700668793921203436297994726315895748830886833733795541939642293570296333945546540425696009019048578741927708392128594641644720204489823294745354601658579814783

def attaque(n, e):
	p = int(isqrt(n))
	assert gcd(n, p) == p

	q = n // p
	assert p * q == n

	phi = (p - 1) * (q - 1)
	d = pow(e, -1, phi)
	return d

d = attaque(n, e)

secret = long_to_bytes(pow(c, d, n))
print(secret.decode())
