from Crypto.Util.number import bytes_to_long, getPrime, isPrime

def generation():
    e = 2 ** 16 + 1            # exposant public
    while True:                # generation des nombres premiers
        p = getPrime(512)
        q = p + 2
        if isPrime(q):
            return e, p * q    # cle publique

# Le but est de retrouver le contenu du fichier "secret.txt"
secret = bytes_to_long(open("secret.txt", "rb").read())
e, n = generation()
c = pow(secret, e, n)          # chiffrement
print(f"{e = }")               # on donne les valeurs publiques
print(f"{n = }")
print(f"{c = }")

'''
Les sorties sont :

e = 65537
n = 66907891761984008537941140774912037297837590014015185566914783649941599498156196985198017994785898068818408452278114397257705910683663630148281632249325838499714790225183956363183023909759661407982053628973343763791901162941487843952027091158708062588427508128442517340524304210772219119731017090655544774543
c = 5133911099057224667169583602683674532556802478109001219004962180674003744338654654215037333471991641567067921343617795171381818207050522146661135917700668793921203436297994726315895748830886833733795541939642293570296333945546540425696009019048578741927708392128594641644720204489823294745354601658579814783

'''
