import numpy as np

from board_util import *
from scope_util import *

# Connect to the board
board = Board()

# Connect to the scope
scope = connect_scope()
channel = 2

# Set the PIN to a random value
pin = list(np.random.randint(10, size=board.PIN_SIZE))
board.set_pin(pin)
print(pin)
board.verify_pin(pin)

nb_traces = 10

# Get 10 power traces and compute the mean power consumption while using good PIN
traces = []
for i in range(nb_traces):
    board.verify_pin(pin, print_message=False)
    trace = scope.get_waveform(channel)
    traces.append(trace)

good_mean = np.mean(traces, 0)
plot_trace(good_mean)

# Get 10 power traces and compute the mean while using wrong PIN
tested_pin = [v for v in pin]

traces = []
for i in range(nb_traces):
    board.verify_pin(tested_pin, print_message=False)
    trace = scope.get_waveform(channel)
    traces.append(trace)

wrong_mean = np.mean(traces, 0)
plot_trace(wrong_mean)

# Compute difference of mean
mean_diff = list(np.array(good_mean) - np.array(wrong_mean))
plot_trace(mean_diff)

# Computing for a specific index the euclidian distance between the
# power consumption means
tested_index = 0
distances = []

tested_pin = [0,0,0,0]

for tested_value in range(board.PIN_MAX_VALUE + 1):
    tested_pin[tested_index] = tested_value
    traces = []
    for i in range(nb_traces):
        board.verify_pin(tested_pin, print_message=False)
        trace = scope.get_waveform(channel)
        traces.append(trace)

    mean_trace = np.mean(traces, 0)
    distance_with_good_trace = np.linalg.norm(np.array(mean_trace)- np.array(good_mean))
    distances.append(distance_with_good_trace)

for i, d in enumerate(distances):
    print("{}: {}".format(i, d))

print("Position {}: {}".format(tested_index, np.argmin(distances)))
