ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

def dechiffrement(texte):
  ## On commence par ecrire une fonction
  ## qui retrouve la cle avec une analyse frequentielle
  def retrouve_cle(texte):
    from collections import Counter
    # On commence par calculer la frequence des lettres
    # par paquets de 5, etant donne que la cle contient 5 caracteres.
    eeeee_chiffre = ""
    for position in range(5):
      frequences = Counter(texte[position::5])
      frequence_max = 0
      e_chiffre = ""
      for lettre, valeur in frequences.items():
        if valeur > frequence_max:
          e_chiffre = lettre
          frequence_max = valeur
      eeeee_chiffre += e_chiffre

    cle = ""
    for a, b in zip("EEEEE", eeeee_chiffre):
      x, y = ALPHABET.index(a), ALPHABET.index(b)
      cle += ALPHABET[(y - x) % 26]

    return cle

  ## Puis on retrouve la cle grace au texte
  cle = retrouve_cle(texte)

  ## On procede enfin au dechiffrement en tant que tel
  clair = ""
  for position, lettre in enumerate(texte):
    x, y = ALPHABET.index(lettre), ALPHABET.index(cle[position % 5])
    clair += ALPHABET[(x - y) % 26]
  return clair, cle

texte_chiffre = "".join(open("ciphertext.txt").read().split())
texte_clair, cle = dechiffrement(texte_chiffre)
print(texte_clair)
print(cle)