import serial

class Board:
    # PIN code messages                                                                                         
    PIN_SET = 0x00
    UNKNOWN_CMD = 0XFF
    PIN_OK = 0x55
    PIN_NOK = 0xaa

    PIN_MESSAGE = {
        PIN_SET: "PIN code set",
        UNKNOWN_CMD: "Unkwown command",
        PIN_OK: "PIN OK",
        PIN_NOK: "PIN NOT OK"
    }

    # PIN commands
    SET_PIN = 0x01
    VERIFY_PIN = 0x02

    PIN_SIZE = 4
    PIN_MAX_VALUE = 9

    def __init__(self, dev="/dev/ttyACM0", baudrate = 115200):
        self.ser = serial.Serial(dev, baudrate)
        print("Waiting for the board to be ready")
        ret = self.ser.readline().decode()
        while not "Set up!" in ret:
            ret = self.ser.readline().decode()
        print("Board is ready")

    # Print the code message
    def print_message(self, code):
        print(self.PIN_MESSAGE[code])

    # Set code PIN
    def set_pin(self, pin, print_message=True):
        cmd = bytes([self.SET_PIN] + pin)
        self.ser.write(cmd)
        if print_message:
            self.print_message(ord(self.ser.read(1)))

    # Verify PIN
    def verify_pin(self, pin, print_message=True):
        cmd = bytes([self.VERIFY_PIN] + pin)
        self.ser.write(cmd)
        if print_message:
            self.print_message(ord(self.ser.read(1)))
