import numpy as np
import matplotlib.pyplot as plt
import time

from board_util import Board
from scope_util import *

# Connect to the board
board = Board()

# Set the pin to a random value
pin = list(np.random.randint(10, size=4))
print("The PIN is: {}".format(pin))
board.set_pin(pin)

# Test pin verification
board.verify_pin(pin)

# Test wrong pin verification
wrong_pin = [0,0,0,0]
board.verify_pin(wrong_pin)

input()

# Connect to the scope
scope = connect_scope()
channel = 1

# Get traces for different number of good values in PIN and plot them
tested_pin = [0,0,0,0]

for nb_correct_val in range(board.PIN_SIZE + 1):
    for i in range(nb_correct_val):
        tested_pin[i] = pin[i]
    print("Test PIN: {}".format(tested_pin))
    board.verify_pin(tested_pin)
    trace = scope.get_waveform(channel)
    X = [i for i in range(len(trace))]
    plt.plot(X, trace, label="{} correct values".format(nb_correct_val))

plt.legend()
plt.show()

input()

# Get traces for different value of at a fixed index
tested_index = 0
tested_pin = [0,0,0,0]

for tested_value in range(board.PIN_MAX_VALUE + 1):
    tested_pin[tested_index] = tested_value
    print("Test PIN: {}".format(tested_pin))
    board.verify_pin(tested_pin)
    time.sleep(0.1)
    trace = scope.get_waveform(channel)
    X = [i for i in range(len(trace))]
    plt.plot(X, trace, label="{}".format(tested_value))

plt.legend()
plt.show()
