  /*
  Software serial multple serial test

 Receives from the hardware serial, sends to software serial.
 Receives from software serial, sends to hardware serial.

 The circuit:
 * RX is digital pin 2 (connect to TX of other device)
 * TX is digital pin 3 (connect to RX of other device)

 Note:
 Not all pins on the Mega and Mega 2560 support change interrupts,
 so only the following can be used for RX:
 10, 11, 12, 13, 50, 51, 52, 53, 62, 63, 64, 65, 66, 67, 68, 69

 Not all pins on the Leonardo support change interrupts,
 so only the following can be used for RX:
 8, 9, 10, 11, 14 (MISO), 15 (SCK), 16 (MOSI).

 created back in the mists of time
 modified 25 May 2012
 by Tom Igoe
 based on Mikal Hart's example

 This example code is in the public domain.

 */
#include <SoftwareSerial.h>

SoftwareSerial targetSerial(2, 3); // RX, TX

char byteRead = 0;
int triggerPin = 12;
int resetPin = 8;

/*
 * We open the serial communication and set
 * the trigger PIN as an output then we reset
 * the target board
 */
void setup() {
  Serial.begin(115200);
  targetSerial.begin(115200);
  pinMode(triggerPin, OUTPUT);
  pinMode(resetPin, OUTPUT);
  digitalWrite(resetPin, LOW);
  delay(500); // Wait 0.5sec to be sure the board received the signal
  digitalWrite(resetPin, HIGH);
}

void loop() {
  digitalWrite(triggerPin, LOW);
  if (targetSerial.available()){
    Serial.write(targetSerial.read());
  }
    
  if (Serial.available()){
    byteRead = Serial.read();
    if(byteRead == 0x02){
      /*
       * If we demande a verify PIN:
       * We send the command, then the 3 first byte of the PIN
       * Then we set the trigger to HIGH and we send the last byte of the PIN
       */
      targetSerial.write(byteRead);
      for(int i=0; i<3; i++){
        if(Serial.available())
          targetSerial.write(Serial.read());
      }
      /*
       * Get the last byte of the PIN before sending it
       * so there is the least time between the rise of the 
       * trigger and the sending
       */
      if(Serial.available())
        byteRead = Serial.read();
      digitalWrite(triggerPin, HIGH);
      targetSerial.write(byteRead);
      /*
       * Wait for the response of the target, set the trigger 
       * to low as soon as you receive it and transmit the response
       * to the PC
       */
       while(targetSerial.available() == 0){}
       digitalWrite(triggerPin, LOW);
       Serial.write(targetSerial.read());
    }
    else{
      /*
       * For any other command than the verifyPIN we just transmit
       * the data
       */
      targetSerial.write(byteRead);
    }
  }
}
