#include <NewPing.h>

//Les quatre lignes suivantes servent à initialiser le module SONAR
#define TRIGGER_PIN  12  // Broche Arduino liée à la broche déclencheur du SONAR
#define ECHO_PIN     13  // Broche Arduino liée à la broche écho du SONAR
#define MAX_DISTANCE 200 // Distance Maximale de l'objet (en cm)que l'on veut mesurer (le capteur peut aller jusque 400 à 500 cm).
NewPing sonar(TRIGGER_PIN, ECHO_PIN, MAX_DISTANCE); // Envoie les données ci-dessus vers le SONAR

void setup() {
  Serial.begin(9600); // Ouvre une liaison avec le moniteur série à 115200 baud afin de visualiser le résultat de l'écho.
}

void loop() {
  delay(500);  // Attend 500 ms entre chaque salve (soit 2 salves par seconde). Le plus court délai entre 2 salves ne doit pas être inférieur à 29 ms
  unsigned int uS = sonar.ping(); // Envoie la salve, et récupère la durée d'aller-retour de la salve (en microsecondes) dans la variable uS.

  Serial.print(340*uS*1E-6/2); 
  // Affiche la distance entre le module SONAR et l'obstacle (affiche zéro s'il ne reçoit pas d'écho)
  Serial.println(); // Passe à la ligne
}







