﻿
#!/usr/bin/env python
#-*- coding: utf-8 -*-
from matplotlib.pyplot import *

donnees = open('C:/travail/GRIESP/ascenseur/mesures.txt','r')
 #indiquer ci-dessus le chemin du fichier mesures.txt

# lecture et exploitation enregistrement des mesures
mesures = donnees.readlines()
dates=[]
accelerations=[]
for val in mesures:
    dates+=[float(val[0:12])] # les 12 premiers caractères sont la date
    accelerations+=[float(val[12:len(val)])] # les caractères suivants correspondent à l'accélération
donnees.close()

# Estimation de g
somme=0
for i in range(378):
    somme+=accelerations[i]
g=somme/378

# Calcul de l'accélération
az=[]
for acceleration in accelerations:
    az+=[acceleration-g]

# Calcul de la vitesse
vz=[0]
for i in range(1,len(dates)):
    vz+=[vz[i-1]+az[i]*(dates[i]-dates[i-1])]

# Calcul de la position
z=[0,0]
for i in range(2,len(dates)):
    z+=[z[i-1]+vz[i]*(dates[i]-dates[i-1])]

# Tracés
subplot(211)
xlabel("temps (s)")
plot(dates,vz,label="vitesse (m/s)")
plot(dates,az,label="accélération (m/s²)")
legend()

subplot(212)
ylabel("altitude (m)")
xlabel("temps (s)")
plot(dates,z,label="position")
legend()
show()

