import numpy as np
import matplotlib.pyplot as plt

# données du problème
m=20
g=9.81
alpha1 = 10*3.14/180 # angle de la force 1 / verticale
alpha2 = 20*3.14/180 # angle de la force 2 / verticale

# caractéristiques du graphique
ax = plt.axes()
taille=1.2*m*g                     
plt.xlim(-taille, taille)
plt.ylim(-taille, taille)


# Tracé des vecteurs force
F1=m*g/(np.cos(alpha1)+np.cos(alpha2)*np.sin(alpha1)/np.sin(alpha2)) # norme de la force 1 
F2=m*g/(np.cos(alpha2)+np.cos(alpha1)*np.sin(alpha2)/np.sin(alpha1)) # norme de la force 2

ax.arrow(0, 0, 0, -m*g, head_width=0.05*taille, head_length=0.1*taille, length_includes_head=True) # poids
ax.arrow(0, 0, np.sin(alpha1)*F1, np.cos(alpha1)*F1, head_width=0.03*taille, head_length=0.1*taille, length_includes_head=True) # force 1 
ax.arrow(0, 0, -np.sin(alpha2)*F2, np.cos(alpha2)*F2, head_width=0.03*taille, head_length=0.1*taille, length_includes_head=True) # force 2 

# Tracé des vecteurs force reliés
ax.arrow(0, -m*g, np.sin(alpha1)*F1, np.cos(alpha1)*F1, head_width=0.03*taille, head_length=0.1*taille, length_includes_head=True) # poids - force 1 
ax.arrow(np.sin(alpha1)*F1, -m*g+np.cos(alpha1)*F1, -np.sin(alpha2)*F2, np.cos(alpha2)*F2, head_width=0.03*taille, head_length=0.1*taille, length_includes_head=True) # force 1 -force 2 

plt.show()