
# coding: utf-8

# # Suites - Réseau social InstaBook

# ## Présentation de l'activité
# - **Niveau de classe :** 
#  - Classe de première de la voie générale (spécialité mathématiques).
#  - Classe de première de la voie technologique (tronc commun).
# - **Références au programme:** 
#  - Spécialité mathématiques de première générale: *Calcul de termes d’une suite, de sommes de termes, de seuil*.
#  - Tronc commun de première de la voie technologique : *Calcul d'un terme de rang donné d’une suite, d'une somme finie de termes*.
#  - Tronc commun de première de la voie technologique : *Déterminer une liste de termes d’une suite et les représenter*.
#  - Tronc commun de première de la voie technologique : *Algorithme de seuil*.
# - **Description :** Activité classique d'étude d'une suite arithmético-géométrique mise en contexte.

# ## Situation
# 
# Le nouveau réseau social $\texttt{InstaBook}$ avait $100\ 000$ inscrits en janvier $2018$. Chaque mois, on peut estimer que $5\%$ des membres se désinscrivent (on arrondira à l'entier inférieur) et qu'il y a $20\ 000$ nouveaux inscrits. Pour un entier naturel $n$, on note $u_{n}$ le nombre d'inscrits au bout de $n$ mois depuis janvier $2018$. Par exemple $u_{0}$ représente le nombre d'inscrits en janvier $2018$ et $u_{5}$ représente le nombre d'inscrits en juin $2018$.

# On a $u_0=100\ 000$ et $\forall n>0,\ u_{n+1}=\textrm{Ent}(0.95\times u_n)+20\ 000$.

# <div class="alert alert-info">
# 
# Suggestions pédagogiques
# 
# </div>
# 
# - **Mathématiques débranchées**
#     - Calculer $u_2$ (sans programmation).
#     - Expliquer la relation de récurrence entre $u_n$ et $u_{n+1}$.

# ## Nombre d'inscrits au bout de $n$ mois
# 
# La fonction `nombreInscrits` prend en paramètre un entier `n` correspondant au nombre de mois écoulés depuis janvier 2018. Elle renvoie la valeur de $u_n$.

# In[1]:


def nombreInscrits(n):
    u = 100000
    for i in range(n):
        u = int(0.95*u)+20000
    return u
print("Nombre d'inscrits au bout de 10 mois :",nombreInscrits(10))


# <div class="alert alert-info">
# 
# Suggestions pédagogiques
# 
# </div>
# 
# - **Compléter un programme** 
# 
#     Le programme précédent étant fourni en remplaçant les lignes 2 et 4 par `u = ...` et `... = ...`, demander aux élèves de compléter les lignes 2 et 4. .
# - **Expliquer un programme**
# 
#     Que fait la ligne 4 ?
# - **Tester** la fonction`nombreInscrits` pour déterminer le nombre d'inscrits en février $2029$.

# # Évolution du nombre d'inscrits
# La fonction `tableauNombreInscrits` prend en paramètre un entier `n` correspondant au nombre de mois écoulés depuis janvier 2018. Elle renvoie une liste contenant les nombres d'inscrits tous les mois jusqu'au $n$-ième mois.

# In[3]:


def tableauNombreInscrits(n): 
    tab = []
    u = 100000
    for i in range(n):
        u = int(0.95*u)+20000
        tab.append(u) 
    return tab


# <div class="alert alert-info">
# 
# Suggestions pédagogiques
# 
# </div>
# 
# - **Compléter un programme**
# 
#     Le programme précédent étant fourni en remplaçant la ligne 6 par `...append(...)`, demander aux élèves de compléter la ligne 6. .
# - **Expliquer un programme**
# 
#     Que fait la  ligne 4 ?
# - **Tester** la fonction `tableauNombreInscrits` pour différentes valeurs et conjecturer une tendance. 

# **Représentation graphique du nombre d'inscrits en fonction du temps**
# 
# Le programme suivant permet la représentation des termes de la suite $(u_n)$ en fonction de $n$ pour $n$ allant de 0 à 100.

# In[4]:


get_ipython().run_line_magic('matplotlib', 'inline')
import matplotlib.pyplot as plt

n = 100

plt.plot(tableauNombreInscrits(n),'.')
plt.show()


# <div class="alert alert-info">
# 
# Suggestions pédagogiques
# 
# </div>
# 
# - **Conjecturer**
# 
#     Quelle conjecture peut-on émettre sur l'évolution du nombre d'inscrits à long terme ? 

# ## Calcul de seuil
# Le réseau social  projette de réaliser des investissements (serveurs, publicité, etc.) à partir de $250\,000$ inscrits. 
# La fonction `seuil` calcule le nombre de mois nécessaires pour atteindre un nombre d'inscrits `k`. Elle prend en paramètres le nombre `k` d'inscrits à atteindre et renvoie le nombre de mois nécessaires.

# In[5]:


def f(x):
    return 0.95*x+20000

def seuil(k):
    u = 100000
    n = 0
    while u<k:
        u = f(u)
        n = n+1
    return n

nbMois = seuil(250000)
print(nbMois)


# <div class="alert alert-info">
# 
# Suggestions pédagogiques
# 
# </div>
# 
# - **Compléter un programme**
# 
#     Le programme précédent étant fourni en remplaçant les lignes 7, 8 et 9 par `while ...`, `... = f(...)`,`n = ...`, demander aux élèves de compléter les lignes 7, 8 et 9.
# - **Expliquer un programme** 
#     
#     Que font les lignes 7, 8 et 9 ?
# - **Tester** la fonction `seuil` afin de déterminer le nombre de mois au bout desquels il faut réaliser des investissements.
# - **Écrire un programme**
#     
#     Écrire une fonction permettant de déterminer le nombre de mois au bout desquels il faut réaliser des investissements.
