#%%
import numpy as np
import matplotlib.pyplot as plt
#%%
ymes=np.array([-0,-0.7,-1.5,-2.3,-3.5,-4.5,-5.9,-7.7,-8.8,-10.6,-12.3,-14.2,-16.4,-18.5,-21,-23.5])
yreelle=ymes*2/100
t=np.linspace(0,1/4,16)

x=0*t
plt.figure()
plt.plot(x,yreelle,'ro',label="y=f(x)")
plt.xlabel("position")
plt.ylabel("yreelle")
plt.grid()
plt.legend()
plt.title("chute libre")
plt.show()
#%%

mod=np.polyfit(t,yreelle,2)
print('mod :', mod)

print('g = ',-mod[0]*2)
print('vo = ', mod[1])
print('yo = ',mod[2])

#%%
ymod=mod[0]*t**2+mod[1]*t+mod[2]
plt.figure()
plt.plot(t,yreelle,'ro',label="yréelle=f(t)")
plt.plot(t,ymod,'b-',label="ymod=f(t)")
plt.xlabel("temps")
plt.ylabel("yreelle")
plt.grid()
plt.legend()
plt.title("chute libre et son modèle")
plt.show()
