
#%%
import numpy as np # on importe numpy
import matplotlib.pyplot as plt # on importe matplotlib
#%%
ymes=np.array([-0,-0.7,-1.5,-2.3,-3.5,-4.5,-5.9,-7.7,-8.8,-10.6,-12.3,-14.2,-16.4,-18.5,-21,-23.5])
# on définit un tableau du type array
yreelle=ymes*2/100
# on convertit ymes en yreelle
t=np.linspace(0,1/4,16)
# on définit un tableau de 16 valeurs allant de 0 à 1/4 
#%%
x=0*t # on définit une abscisse nulle, ce qui permettra de tracer en fonction de l'abscisse
plt.figure()
plt.plot(x,yreelle,'ro',label="y=f(x)") # on trace yreelle en fonction de x 
plt.xlabel("position") # pour le reste, il s'agit des options classiques de tracé
plt.ylabel("yreelle")
plt.grid()
plt.legend()
plt.title("chute libre")
plt.show()
#%%
mod=np.polyfit(t,yreelle,2)
# on fait modéliser yreelle en fonction de t par un polynôme d'ordre 2, type at^2+bt+c. 
# Attention : cette fonction n'est pas un ensemble de valeurs mais simplement une fonction
# donc un objet de dimension 1. Pour pouvoir faire tracer cette fonction, il faudra dans la suite définir 
# une fonction modèle qui utilise les paramètres du modèle
print('mod :', mod)
# on fait afficher les trois paramètres de ce polynôme modèle d'ordre 2 : a, b et c.
print('g = ',-mod[0]*2)
print('vo = ', mod[1])
print('yo = ',mod[2])
#%%
ymod=mod[0]*t**2+mod[1]*t+mod[2] # on définit la fonction modèle avec les grandeurs a, b et c déterminées précédemment.
plt.figure()
plt.plot(t,yreelle,'ro',label="yréelle=f(t)") # on fait tracer yreelle en fonction de t
plt.plot(t,ymod,'b-',label="ymod=f(t)") # sur le même graphe, on fait tracer en trait bleu la fonction modèle ymod
plt.xlabel("temps") # dans la suite, il s'agit des options classiques de tracé
plt.ylabel("yreelle")
plt.grid()
plt.legend()
plt.title("chute libre et son modèle")
plt.show()
#%%