# -*- coding: utf-8 -*-
"""
Created on Sat Feb 16 12:58:44 2019

@author: THOMAS
"""

import numpy as np
from matplotlib import pyplot

##########################################################################
#Renvoie une valeur aléatoire de la variable L[0] d'incertitude-type L[1]
def Alea(L):
    tirage=np.random.normal()
    return L[0]+L[1]*tirage
##########################################################################
   
##########################################################################
#Entrées
m0=[4.12,0.01]
Vf=[100.00e-3,0.05e-3]
Vp=[10.00e-3,0.02e-3]
c1=[0.1000,0.0003]
M=[39.9971,0.0004]
Veq=[10.7e-3,0.2e-3]
##########################################################################

##########################################################################
#Méthode de Monte Carlo pour le titre massique de NaOH
LwNaOH=[]
Iteration=100000

for j in range(Iteration):
    AleawNaOH=Alea(M)*Alea(c1)*Alea(Veq)*Alea(Vf)/(Alea(m0)*Alea(Vp))
    LwNaOH.append(AleawNaOH)

MoywNaOH=sum(LwNaOH)/Iteration
uwNaOH=(1/(Iteration-1)*sum((np.array(LwNaOH)-MoywNaOH)**2.))**0.5

print('Titre massique d hydroxyde de sodium du DesTop :', 100*MoywNaOH,' %')
print('u(wNaOH) :', 100*uwNaOH,' %')
pyplot.hist(LwNaOH, range = (0.095, 0.112), bins = 50, color = 'blue', edgecolor = 'black')
pyplot.xlabel('wNaOH')
pyplot.ylabel('effectif')
pyplot.title('Pour 100 000 iterations')
pyplot.show()
##########################################################################
