# -*- coding: utf-8 -*-
"""
Created on Sat Feb 16 12:58:44 2019

@author: THOMAS
"""

import numpy as np
from matplotlib import pyplot

##########################################################################
#Procedure Regression Linéaire ; tableaux np X et Y
def RegLin(X,Y):
    N=len(X)
    moyX=sum(X)/N
    moyY=sum(Y)/N
    pente=sum((X-moyX)*(Y-moyY))/(sum((X-moyX)**2))
    ordor=moyY-pente*moyX
    return [pente,ordor]

##########################################################################
#Renvoie une valeur aléatoire de la variable L[0] d'incertitude-type L[1]
def Alea(L):
    tirage=np.random.normal()   #Tirage entre -infini et +infini (loi normale)
    return L[0]+L[1]*tirage
##########################################################################
   
##########################################################################
#Entrées (groupe 1)
m=[297.e-3,1.e-3]
M=[582.66,0.01]
Vf1=[1.0000,0.0008]
Vp=[10.00e-3,0.02e-3]
Vf2=[250.0e-3,0.3e-3]
Dilutions=[10.00e-3,7.50e-3,5.00e-3,2.50e-3,1.00e-3]
Ajustements=[0,2.50e-3,5.00e-3,7.50e-3,9.00e-3]
DeltaBurette=0.2e-3
Absorbance=[1.765,1.376,0.813,0.428,0.138]
ErelSpectro=0.02
Report=[0.665,0.02*0.665]
Vf3=[50.00e-3,0.05e-3]
##########################################################################

##########################################################################
#Préparation des listes avec incertitudes
Dilu=[]
for k in range(len(Dilutions)):
    Dilu.append([Dilutions[k],DeltaBurette])

Ajust=[]
for k in range(len(Dilutions)):
    if Ajustements[k]==0:
        Ajust.append([Ajustements[k],0])
    else:
        Ajust.append([Ajustements[k],DeltaBurette])

A=[]
for k in range(len(Dilutions)):
    A.append([Absorbance[k],Absorbance[k]*ErelSpectro])
##########################################################################
    
##########################################################################
#Méthode de Monte Carlo pour le nombre de bonbons
LNbonbon=[]
Iteration=100000

for j in range(Iteration):
    AleaM=Alea(M)
    AleaCm=Alea(m)/(AleaM*Alea(Vf1))
    AleaC0=AleaCm*Alea(Vp)/Alea(Vf2)
    AleaC=[]
    AleaA=[]
    for k in range(len(Dilutions)):
        AleaC.append(AleaC0/(1+Alea(Ajust[k])/Alea(Dilu[k])))
        AleaA.append(Alea(A[k]))
    AleaReport=Alea(Report)

    Pente=RegLin(np.array(AleaC),np.array(AleaA))[0]
    OrdOr=RegLin(np.array(AleaC),np.array(AleaA))[1]
    Cs=(AleaReport-OrdOr)/Pente
    LNbonbon.append(2.5e-3*70/(AleaM*Cs*Alea(Vf3)))

MoyNbonbon=sum(LNbonbon)/Iteration
uNbonbon=(1/(Iteration-1)*sum((np.array(LNbonbon)-MoyNbonbon)**2.))**0.5

print('Un élève pourrait manger :', int(MoyNbonbon), 'bonbons...')
print('Incertitude-type de ce nombre de bonbons :',int(uNbonbon))
pyplot.hist(LNbonbon, range = (700,820), bins = 50, color = 'blue', edgecolor = 'black')
pyplot.xlabel('Nombre de bonbons que l élève peut manger')
pyplot.ylabel('effectif')
pyplot.title('Pour 100 000 iterations')
pyplot.show()
##########################################################################
