# -*- coding: utf-8 -*-
"""
Created on Sat Feb 16 12:58:44 2019

@author: THOMAS
"""

import numpy as np

##########################################################################
#Renvoie une valeur aléatoire de la variable L[0] d'incertitude-type L[1]
def Alea(L):
    tirage=np.random.normal()   #Tirage entre -infini et +infini (loi normale)
    return L[0]+L[1]*tirage

##########################################################################
#Entrées
m=[297.e-3,1.e-3]
M=[582.66,0.01]
Vf1=[1.0000,0.0008]
Vp=[10.00e-3,0.02e-3]
Vf2=[250.0e-3,0.3e-3]
Dilutions=[10.00e-3,7.50e-3,5.00e-3,2.50e-3,1.00e-3]
Ajustements=[0,2.50e-3,5.00e-3,7.50e-3,9.00e-3]
DeltaBurette=0.05e-3
##########################################################################

##########################################################################
#Préparation de la liste des concentrations des solutions diluées
Cm=m[0]/(M[0]*Vf1[0])
C0=Cm*Vp[0]/Vf2[0]
Concentration=[]
for k in range(len(Dilutions)):
    Concentration.append(C0*Dilutions[k]/(Dilutions[k]+Ajustements[k]))
##########################################################################

##########################################################################
#Méthode de Monte Carlo pour trouver l'incertitude sur C
#sans composition des incertitudes
for k in range(len(Dilutions)):
    Dilu=[Dilutions[k],DeltaBurette]
    if Ajustements[k]==0:
        Ajust=[Ajustements[k],0]
    else:
        Ajust=[Ajustements[k],DeltaBurette]
    LC=[]
    iteration=100000
    for i in range(iteration):
        AleaCm=Alea(m)/(Alea(M)*Alea(Vf1))
        AleaC0=AleaCm*Alea(Vp)/Alea(Vf2)
        AleaC=AleaC0*1/(1+Alea(Ajust)/Alea(Dilu))
        LC.append(AleaC)

    MoyC=sum(LC)/iteration
    uC=(1/(iteration-1)*sum((np.array(LC)-MoyC)**2.))**0.5
    print('Tube n°',k+1)
    print('Calcul de C :',Concentration[k])
    print('Moyenne des C :',MoyC)
    print('u(C) :',uC)
##########################################################################

