# -*- coding: utf-8 -*-
"""
Created on Sat Feb 16 12:58:44 2019

@author: THOMAS
"""

import numpy as np
import matplotlib.pyplot as plt

##########################################################################
#Procedure Regression Linéaire ; tableaux np X et Y
def RegLin(X,Y):
    N=len(X)
    moyX=sum(X)/N
    moyY=sum(Y)/N
    pente=sum((X-moyX)*(Y-moyY))/(sum((X-moyX)**2))
    ordor=moyY-pente*moyX
    return [pente,ordor]

#Tracé d'une droite px+o entre les abscisses a et b, n points
def Droite(p,o,a,b,n):
    xx=np.linspace(a,b,n)
    yy=p*xx+o
    plt.plot(xx,yy,linewidth=0.5)
    
#Renvoie l'incertitude-type de la pente ; tableaux np X et Y
def PenteIncerType(X,Y):
    N=len(X)
    Ypredict=RegLin(X,Y)[0]*X+RegLin(X,Y)[1]    
    moyX=sum(X)/N
    return np.sqrt(sum((Y-Ypredict)**2)/((N-2)*sum((X-moyX)**2)))

#Renvoie l'incertitude-type de l'ordonnée à l'origine ; tableaux np X et Y
def OrdOrIncerType(X,Y):
    N=len(X)
    Ypredict=RegLin(X,Y)[0]*X+RegLin(X,Y)[1]    
    moyX=sum(X)/N
    return np.sqrt(sum((Y-Ypredict)**2)*sum(X**2)/(N*(N-2)*sum((X-moyX)**2)))
##########################################################################
    
##########################################################################
#Entrées (groupe 1)
C=np.array([2.04e-5,1.53e-5,1.02e-5,5.1e-6,2.0e-6])
A=np.array([1.765,1.376,0.813,0.428,0.138])
##########################################################################

##########################################################################
#Régression linéaire
RegBeerLamb=RegLin(C,A)
plt.figure(1)
plt.scatter(C,A,s=10)
Droite(RegBeerLamb[0],RegBeerLamb[1],0,2.5e-5,10)
plt.xlabel(r"$C (mol.L^{-1})$")
plt.ylabel(r"$A$")
plt.axis([0,2.5e-5, 0, 2])
plt.savefig('BeerLambert.eps')
plt.show()
###########################################################################

###########################################################################
#Calcul statistique des incertitudes-type de la pente et de 
#l'ordonnée à l'origine (loi normale supposée pour X et Y)
uP=PenteIncerType(C,A)
uOrdOr=OrdOrIncerType(C,A)
print('Pente :',RegBeerLamb[0])
print('Incertitude-type de la pente :',uP)
print('Ordonnee à l origine :',RegBeerLamb[1])
print('Incertitude-type de l ordonnée à l origine :',uOrdOr)
###########################################################################
