/*
 * Ce programme émet un signal toutes les secondes
 * vers le récepteur pour qu'il mesure la puissance du signal de réception
 */

#include <SoftwareSerial.h>

const int RX = 2;   
const int TX = 3;

const int baudRate = 9600;      

const char *PANID = "1010";      
const char *MYID  = "190";      
const char *DLID  = "180";     
const char *CHID  = "11";         

SoftwareSerial Xbee(TX, RX);


void setup()
{
  Serial.begin(baudRate);            // liaison série de la console (débugage)
  Xbee.begin(baudRate);        // Liaison série du module XBEE
  
  Serial.println("init");
  setXBEE("+++");

  // attente réponse OK de la commande AT Hayes
  char thisByte = 0;
  while ( thisByte != '\r' )
    if ( Xbee.available() > 0 ) {
      thisByte = Xbee.read();
      Serial.print(thisByte);
      }
  Serial.println();

  char  buffer[11];
  setXBEE("ATRE\r");        // configuration usine par defaut
  setXBEE(strcat(strcat(strcpy(buffer,"ATID"), PANID), "\r"));    // adresse du reseau PAN
  setXBEE(strcat(strcat(strcpy(buffer,"ATMY"), MYID), "\r"));    // set my address using 16-bit addressing
  setXBEE(strcat(strcat(strcpy(buffer,"ATDL"), DLID), "\r"));    // adresse de destination sur 16 bits  
  setXBEE(strcat(strcat(strcpy(buffer,"ATCH"), CHID), "\r"));    // canal 3
  setXBEE("ATDH0\r");       // pas de partie haute, adresse 16 bits
 // setXBEE("ATCE0\r");        // end device
  setXBEE("ATWR\r");        // enregistrement
  setXBEE("ATCN\r");        // put the radio in data mode
    
  // attente réponse commandes AT
  while ( Xbee.available() < 0 );
  
  char c = Xbee.read();
  while ( c != -1 ) {
    if ( c != '\r' )
      Serial.print(c);
    else
      Serial.print(" ");
    c = Xbee.read();
    }
  Serial.println("ready to send");
}

void loop()
{
	// émission toutes les secondes
    Xbee.print("HI\r");
    delay(1000) ;
}

void setXBEE(const char *buffer)
{ 
  Serial.println(buffer);
  Serial.print("sent: "); Serial.println(Xbee.print(buffer));
  Xbee.flush();
  delay(100);
}
