/*
 xbee.h
*/

#include <SoftwareSerial.h>

class XBee
{
    private:
		SoftwareSerial *xbeeSerial;
		int digitalPin;
    public:
		XBee(const int, const int, const int);
		void init(const char *, const char *, const char *, const char *);
		int rssi();
    private:
		void setXBEE(const char *);
		void waitATresponse();
};

XBee::XBee(const int TX = 3, const int RX = 2, const int baudrate = 9600)
{
  Serial.begin(baudrate);            // liaison série de la console (débugage)
	
  xbeeSerial = new SoftwareSerial(TX, RX);     // pin 2 = RX Arduino, pin3 = TX Arduino 
	xbeeSerial->begin(baudrate);
	digitalPin = 10;  // the RSSI pin 6 of Xbee is connected to this PWM Pin. (Digital Pin 10)
}

void XBee::init(const char *CHID, const char *PANID, const char *MYID, const char *DLID)
{ 
  setXBEE("+++");
  
  waitATresponse();
  
  char  buffer[11];
  setXBEE("ATRE\r");        // configuration usine par defaut
  setXBEE(strcat(strcat(strcpy(buffer,"ATCH"), CHID), "\r"));    // canal
  setXBEE(strcat(strcat(strcpy(buffer,"ATID"), PANID), "\r"));    // adresse du reseau PAN
  setXBEE(strcat(strcat(strcpy(buffer,"ATMY"), MYID), "\r"));    // set my address using 16-bit addressing
  setXBEE(strcat(strcat(strcpy(buffer,"ATDL"), DLID), "\r"));    // adresse de destination sur 16 bits  
  setXBEE("ATDH0\r");       // pas de partie haute, adresse 16 bits
  setXBEE("ATCE0\r");        // end device
  setXBEE("ATWR\r");        // enregistrement
  setXBEE("ATCN\r");        // put the radio in data mode
  
  waitATresponse();
}

int XBee::rssi()
{
	int rssiDur = 0;

	if ( xbeeSerial->read() == 0x7E ) {  // Reads the start byte
	    pinMode(digitalPin, INPUT);
		
		for(int i = 1; i < 19; i++) {
			char discardByte = xbeeSerial->read();

			rssiDur += pulseIn(digitalPin, LOW, 200); // get's the RSSI Value
			}
		}
	
	return rssiDur / 18;
}

void XBee::setXBEE(const char *buffer)
{ 
  Serial.println(buffer);
  Serial.print("sent: "); Serial.println(xbeeSerial->print(buffer));
  delay(100);
}

void XBee::waitATresponse()
{ 
	// attente réponse commandes AT
	while ( xbeeSerial->available() < 0 );
	
	char discardByte = xbeeSerial->read();
	while ( discardByte != -1 ) {
		Serial.print(discardByte);
		discardByte = xbeeSerial->read();
		}
}
