/*
 ultrasonic.h
*/

class Ultrasonic
{
    public:
		Ultrasonic(const int pin);
		void DistanceMeasure(void);
		const double microsecondsToCentimeters(void);
		const double microsecondsToInches(void);
    private:
		int  this_pin;	//pin number of Arduino that is connected with SIG pin of Ultrasonic Ranger.
		long duration;	// the Pulse time received;
};
Ultrasonic::Ultrasonic(const int pin)
{
    this_pin = pin;
}
/*Begin the detection and get the pulse back signal*/
void Ultrasonic::DistanceMeasure(void)
{
    pinMode(this_pin, OUTPUT);
    digitalWrite(this_pin, LOW);
    delayMicroseconds(2);
    digitalWrite(this_pin, HIGH);
    delayMicroseconds(5);
    digitalWrite(this_pin, LOW);
    pinMode(this_pin, INPUT);
	
    duration = pulseIn(this_pin,HIGH);
}
/*The measured distance from the range 0 to 400 Centimeters*/
const double Ultrasonic::microsecondsToCentimeters(void)
{
	DistanceMeasure();// get the current signal time;
    return duration/29.0/2.0;
}
/*The measured distance from the range 0 to 157 Inches*/
const double Ultrasonic::microsecondsToInches(void)
{
	DistanceMeasure();// get the current signal time;
    return duration/74.0/2.0;
}
