/*
 This is a sketch for RSSI-Measurements. The sketch reads the incoming RSSI Value.
 Please note that the used Value (40) depends on your project environement.

 ATTENTION!!!
 ---------------------------------------------
 Connect your Xbee RX to Arduino RX!
 Connect your Xbee TX to Arduino TX!
 And don't forget the power supply!
 RSSI Pin on Xbee -> 6
 ---------------------------------------------
*/

#include <Arduino.h>
#include "ultrasonic.h"
#include "xbee.h"

const int baudRate = 9600;

const char *CHID  = "10";        // n° de canal
const char *PANID = "1111";      // adresse reseau
const char *MYID  = "1002";      // adresse du XBee
const char *DLID  = "1001";      // adresse de destination

const int usPin      = 2;

Ultrasonic ultrasonic(usPin);
XBee xb;

void setup()
{
  Serial.begin(baudRate);
  xb.init(CHID, PANID, MYID, DLID);
}

void loop()
{
  double RangeInCentimeters = ultrasonic.microsecondsToCentimeters();	//conversion temps -> centimetres
  Serial.println("La distance à l'obstacle est : ");
  Serial.print(RangeInCentimeters);	//0~400cm
  Serial.println(" cm");
  Serial.print("rssi: ");
	Serial.println(xb.rssi());

	delay(1000);
}
