#include <SoftwareSerial.h>
#include <Servo.h>

const bool debug = false;

// NB : positionner RX = 10 et TX = 11 pour une Arduino MEGA
const int RX = 2;    // pin Shield Arduino pour reception
const int TX = 3;    // pin Shield Arduino pour transmission

const int baudRate = 9600;      // vitesse

const char *PANID = "1010";      // adresse reseau
const char *MYID  = "180";      // adresse du XBee
const char *DLID  = "190";      // adresse de destination
const char *CHID  = "11";         // n° de canal

const int digitalPin = 6;
const int servoPin   = 9;

SoftwareSerial xbeeSerial(TX, RX);     // pin 2 = RX Arduino, pin3 = TX Arduino 
Servo servo;
int Angle = 90;

void setup()
{ 
  pinMode(digitalPin, INPUT);
  servo.attach(servoPin);
  servo.write(Angle);
  
  Serial.begin(baudRate);            // liaison série de la console (débugage)
  xbeeSerial.begin(baudRate);        // Liaison série du module XBEE
  
  Serial.println("init");
  setXBEE("+++");

  // attente réponse commandes AT
  waitATresponse();

  char  buffer[11];
  setXBEE("ATRE\r");        // configuration usine par defaut
  setXBEE(strcat(strcat(strcpy(buffer,"ATID"), PANID), "\r"));    // adresse du reseau PAN
  setXBEE(strcat(strcat(strcpy(buffer,"ATMY"), MYID), "\r"));     // set address 
  setXBEE(strcat(strcat(strcpy(buffer,"ATDL"), DLID), "\r"));     // adresse de destination  
  setXBEE(strcat(strcat(strcpy(buffer,"ATCH"), CHID), "\r"));     // canal 3
  setXBEE("ATDH0\r");        // pas de partie haute, adresse 16 bits
  setXBEE("ATCE0\r");        // end device
  setXBEE("ATWR\r");         // enregistrement
  //setXBEE("ATCN\r");   // put the radio in data mode
  setXBEE("ATCC\r");
    
  // attente réponse commandes AT
  waitATresponse();
  
  Serial.println("ready to receive");
}

void loop()
{
  char  inputByte = xbeeSerial.read();
 
  if ( inputByte > 0 ) {
	  if ( debug ) 
		Serial.print(inputByte, HEX);
    
    if ( inputByte == '\r' ) {   // caractère de fin (CR = 0x0D)
      Serial.println("");
      traitement();
      }
    else
      Serial.print(inputByte);
    }
    
  delay(100);
 }

void traitement()
{
    Serial.println("Positionnez le récepteur à la position en Face");   //mesure de l'intensité du signal en face
    delay (8000);
    servo.write(Angle);

	unsigned long Face = pulseIn(digitalPin, HIGH,200);
	afficheSignal("rssi en Face ",Face);

    Serial.println("Positionnez le récepteur à la position gauche");  //mesure de l'intensité du signal à gauche
    delay (8000);
    servo.write(Angle - 10);

	unsigned long Gauche = pulseIn(digitalPin, HIGH,200);
    afficheSignal("rssi Gauche ", Gauche);

    Serial.println("Positionnez le récepteur à la position droite"); //mesure de l'intensité du signal à droite
    delay (8000);
    servo.write(Angle + 10);
	
	unsigned long Droite = pulseIn(digitalPin, HIGH,200);
    afficheSignal("rssi Droite ", Droite);

	if ((Face > Droite) && (Face > Gauche)|| (Face == Gauche) && (Face > Droite) || (Face == Droite) && (Face > Gauche) || (Gauche == Droite) && (Gauche > Face) || (Face == Gauche) && (Gauche == Droite))
		Serial.println("Angle  en Face  ");
	else if ((Gauche > Droite) && (Gauche > Face)){
		Angle -= 10;
		Serial.println("Angle à Gauche ");
		}  
	else if ((Droite > Gauche) && (Droite > Face)){
		Angle += 10;
		Serial.println("Angle à Droite ");
		}
		
	Serial.println();
	Serial.println("Placez l'émetteur sur une autre position (en face, à droite ou à gauche)");
	Serial.println("Vous avez 8 secs:");

	for (int i(8); i>=0; i--) {
	   Serial.print(i);
	   Serial.print(", ");
	   delay (1000);
	   }
   
	for (int i=0; i < 4; i++)
		Serial.println();
}

void afficheSignal(const char *texte, unsigned long rssi)
{
	if ( rssi == 0 ) // si pas de pulse  signal à 100%
		rssi = 64;

	const float pourcentage = 100. * rssi / 64;
	
	Serial.print(texte);
	Serial.println(rssi);
	Serial.print("Pourcentage reception : ");
	Serial.println(pourcentage); 
	Serial.println();
   
	delay (3000);
}

void setXBEE(const char *buffer)
{ 
  Serial.println(buffer);
  Serial.print("sent: "); Serial.println(xbeeSerial.print(buffer));
  delay(100);
}

void waitATresponse()
{
  while ( xbeeSerial.available() < 0 );
  
  char c = xbeeSerial.read();
  while ( c != -1 ) {
    Serial.print(c);
    c = xbeeSerial.read();
    }
}

